/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors.designer;

import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.controls.io.FloatSimpleIO;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.api2.client.gui.resources.colors.GuiColorPulse;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.lines.BoxLine;
import betterquesting.api2.client.gui.resources.lines.IGuiLine;
import betterquesting.api2.client.gui.resources.textures.ColorTexture;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.storage.DBEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Keyboard;

public class PanelToolController
implements IGuiPanel {
    private CanvasQuestLine questLine;
    private final IGuiRect transform;
    private boolean enabled = true;
    private final IValueIO<Float> scDriverX;
    private final IValueIO<Float> scDriverY;
    private IToolboxTool activeTool;
    public static final NonNullList<PanelButtonQuest> selected = NonNullList.func_191196_a();
    public static final List<IGuiPanel> highlights = new ArrayList<IGuiPanel>();
    private GuiRectangle selBounds;
    private IGuiLine selLine = new BoxLine();
    private IGuiColor selCol = new GuiColorPulse(-1, -16777216, 2.0, 0.0f);
    private IGuiTexture hTex = new ColorTexture(new GuiColorPulse(0x22FFFFFF, 0x77FFFFFF, 2.0, 0.0f));

    public PanelToolController(IGuiRect rect, CanvasQuestLine questLine) {
        this.transform = rect;
        this.questLine = questLine;
        this.scDriverX = new FloatSimpleIO(){

            @Override
            public void writeValue(Float value) {
                this.v = PanelToolController.this.activeTool != null && !PanelToolController.this.activeTool.clampScrolling() ? value.floatValue() : MathHelper.func_76131_a((float)value.floatValue(), (float)0.0f, (float)1.0f);
            }
        }.setLerp(true, 0.02f);
        this.scDriverY = new FloatSimpleIO(){

            @Override
            public void writeValue(Float value) {
                this.v = PanelToolController.this.activeTool != null && !PanelToolController.this.activeTool.clampScrolling() ? value.floatValue() : MathHelper.func_76131_a((float)value.floatValue(), (float)0.0f, (float)1.0f);
            }
        }.setLerp(true, 0.02f);
    }

    public void setActiveTool(IToolboxTool tool) {
        if (this.activeTool != null) {
            this.activeTool.disableTool();
        }
        if (tool == null) {
            return;
        }
        this.activeTool = tool;
        tool.initTool(this.questLine);
    }

    public IToolboxTool getActiveTool() {
        return this.activeTool;
    }

    public void changeCanvas(@Nonnull CanvasQuestLine canvas) {
        this.questLine = canvas;
        this.refreshCanvas();
        this.setActiveTool(this.getActiveTool());
    }

    public void refreshCanvas() {
        ArrayList<PanelButtonQuest> tmp = new ArrayList<PanelButtonQuest>();
        for (PanelButtonQuest b1 : selected) {
            for (PanelButtonQuest b2 : this.questLine.getQuestButtons()) {
                if (((DBEntry)b1.getStoredValue()).getID() != ((DBEntry)b2.getStoredValue()).getID()) continue;
                tmp.add(b2);
            }
        }
        selected.clear();
        selected.addAll(tmp);
        highlights.clear();
        for (PanelButtonQuest btn : selected) {
            highlights.add(new PanelGeneric(btn.rect, this.hTex));
        }
        if (this.activeTool != null) {
            this.activeTool.refresh(this.questLine);
        }
    }

    public CanvasQuestLine getCanvas() {
        return this.getCanvas();
    }

    public IValueIO<Float> getScrollX() {
        return this.scDriverX;
    }

    public IValueIO<Float> getScrollY() {
        return this.scDriverY;
    }

    @Override
    public IGuiRect getTransform() {
        return this.transform;
    }

    @Override
    public void initPanel() {
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        if (!this.enabled) {
            return;
        }
        if (this.activeTool != null) {
            float zs = this.questLine.getZoom();
            int lsx = this.questLine.getScrollX();
            int lsy = this.questLine.getScrollY();
            int tx = this.getTransform().getX();
            int ty = this.getTransform().getY();
            int smx = (int)((float)(mx - tx) / zs) + lsx;
            int smy = (int)((float)(my - ty) / zs) + lsy;
            GlStateManager.func_179094_E();
            RenderUtils.startScissor(this.transform);
            GlStateManager.func_179109_b((float)((float)tx - (float)lsx * zs), (float)((float)ty - (float)lsy * zs), (float)0.0f);
            GlStateManager.func_179152_a((float)zs, (float)zs, (float)zs);
            if (this.selBounds != null) {
                this.selBounds.w = smx - this.selBounds.x;
                this.selBounds.h = smy - this.selBounds.y;
                this.selLine.drawLine(this.selBounds, this.selBounds, 2, this.selCol, partialTick);
            }
            for (IGuiPanel pn : highlights) {
                pn.drawPanel(smx, smy, partialTick);
            }
            this.activeTool.drawCanvas(smx, smy, partialTick);
            RenderUtils.endScissor();
            GlStateManager.func_179121_F();
            this.activeTool.drawOverlay(mx, my, partialTick);
        }
    }

    @Override
    public boolean onMouseClick(int mx, int my, int button) {
        if (this.activeTool != null && this.getTransform().contains(mx, my)) {
            if (this.activeTool.onMouseClick(mx, my, button)) {
                return true;
            }
            if (this.activeTool.useSelection()) {
                if (button == 1) {
                    this.selBounds = null;
                    selected.clear();
                    highlights.clear();
                    this.activeTool.onSelection(selected);
                    return true;
                }
                if (button == 0) {
                    float zs = this.questLine.getZoom();
                    int lsx = this.questLine.getScrollX();
                    int lsy = this.questLine.getScrollY();
                    int tx = this.questLine.getTransform().getX();
                    int ty = this.questLine.getTransform().getY();
                    int smx = (int)((float)(mx - tx) / zs) + lsx;
                    int smy = (int)((float)(my - ty) / zs) + lsy;
                    this.selBounds = new GuiRectangle(smx, smy, 0, 0);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int button) {
        if (this.selBounds != null) {
            boolean subtract;
            if (this.selBounds.w < 0) {
                this.selBounds.x += this.selBounds.w;
                this.selBounds.w *= -1;
            }
            if (this.selBounds.h < 0) {
                this.selBounds.y += this.selBounds.h;
                this.selBounds.h *= -1;
            }
            boolean append = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            boolean bl = subtract = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
            if (!append && !subtract) {
                selected.clear();
            }
            for (PanelButtonQuest btn : this.questLine.getQuestButtons()) {
                if (!this.selBounds.contains(btn.rect.x + btn.rect.w / 2, btn.rect.y + btn.rect.h / 2) && (!btn.rect.contains(this.selBounds.x, this.selBounds.y) || Math.max(this.selBounds.w, this.selBounds.h) >= 4)) continue;
                if (subtract) {
                    selected.remove((Object)btn);
                    continue;
                }
                if (append && selected.contains((Object)btn)) continue;
                selected.add((Object)btn);
            }
            highlights.clear();
            for (PanelButtonQuest btn : selected) {
                highlights.add(new PanelGeneric(btn.rect, this.hTex));
            }
            this.selBounds = null;
            if (this.activeTool != null) {
                this.activeTool.onSelection(selected);
            }
        }
        if (this.activeTool != null) {
            return this.activeTool.onMouseRelease(mx, my, button);
        }
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        if (this.activeTool != null) {
            return this.activeTool.onMouseScroll(mx, my, scroll);
        }
        return false;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        if (this.activeTool != null) {
            if (this.activeTool.onKeyPressed(c, keycode)) {
                return true;
            }
            if (this.activeTool.useSelection() && keycode == 30) {
                boolean subtract;
                boolean append = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
                boolean bl = subtract = append && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                if (subtract) {
                    this.selBounds = null;
                    selected.clear();
                    highlights.clear();
                    this.activeTool.onSelection(selected);
                    return true;
                }
                if (append) {
                    selected.clear();
                    highlights.clear();
                    for (PanelButtonQuest btn : this.questLine.getQuestButtons()) {
                        selected.add((Object)btn);
                        highlights.add(new PanelGeneric(btn.rect, this.hTex));
                    }
                    this.selBounds = null;
                    this.activeTool.onSelection(selected);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        if (this.selBounds != null) {
            return Collections.emptyList();
        }
        if (this.activeTool != null) {
            return this.activeTool.getTooltip(mx, my);
        }
        return null;
    }
}

